/*
 * Copyright (c) 2004, Adam Dunkels.
 * All rights reserved. 
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met: 
 * 1. Redistributions of source code must retain the above copyright 
 *    notice, this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright 
 *    notice, this list of conditions and the following disclaimer in the 
 *    documentation and/or other materials provided with the distribution. 
 * 3. Neither the name of the Institute nor the names of its contributors 
 *    may be used to endorse or promote products derived from this software 
 *    without specific prior written permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND 
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE 
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE 
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS 
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT 
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY 
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF 
 * SUCH DAMAGE. 
 *
 * This file is part of the Contiki operating system.
 * 
 * Author: Adam Dunkels <adam@sics.se>
 *
 * $Id: httpd-fsdata.c,v 1.3 2004/09/12 20:30:03 adamdunkels Exp $
 */
static const char data_cgi_processes[] = {
	/* /cgi/processes */
	0x2f, 0x63, 0x67, 0x69, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0,
	0x69, 0x20, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x2e, 
	0x68, 0x74, 0x6d, 0x6c, 0xa, 0x74, 0x20, 0x3c, 0x68, 0x31, 
	0x3e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x20, 0x70, 0x72, 
	0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x3c, 0x2f, 0x68, 
	0x31, 0x3e, 0x3c, 0x62, 0x72, 0x3e, 0x3c, 0x74, 0x61, 0x62, 
	0x6c, 0x65, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 
	0x31, 0x30, 0x30, 0x25, 0x22, 0x3e, 0xa, 0x74, 0x20, 0x3c, 
	0x74, 0x72, 0x3e, 0x3c, 0x74, 0x68, 0x3e, 0x49, 0x44, 0x3c, 
	0x2f, 0x74, 0x68, 0x3e, 0x3c, 0x74, 0x68, 0x3e, 0x4e, 0x61, 
	0x6d, 0x65, 0x3c, 0x2f, 0x74, 0x68, 0x3e, 0x3c, 0x74, 0x68, 
	0x3e, 0x49, 0x64, 0x6c, 0x65, 0x20, 0x68, 0x61, 0x6e, 0x64, 
	0x6c, 0x65, 0x72, 0x3c, 0x2f, 0x74, 0x68, 0x3e, 0x3c, 0x74, 
	0x68, 0x3e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x20, 0x68, 
	0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x3c, 0x2f, 0x74, 0x68, 
	0x3e, 0x3c, 0x74, 0x68, 0x3e, 0x54, 0x43, 0x50, 0x2f, 0x49, 
	0x50, 0x20, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x72, 0x3c, 
	0x2f, 0x74, 0x68, 0x3e, 0x3c, 0x2f, 0x74, 0x72, 0x3e, 0xa, 
	0x63, 0x20, 0x63, 0xa, 0x74, 0x20, 0x3c, 0x2f, 0x74, 0x61, 
	0x62, 0x6c, 0x65, 0x3e, 0xa, 0x69, 0x20, 0x2f, 0x66, 0x6f, 
	0x6f, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x6c, 0x61, 0x69, 0x6e, 
	0xa, 0x2e, };

static const char data_cgi_tcp[] = {
	/* /cgi/tcp */
	0x2f, 0x63, 0x67, 0x69, 0x2f, 0x74, 0x63, 0x70, 0,
	0x69, 0x20, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x2e, 
	0x68, 0x74, 0x6d, 0x6c, 0xa, 0x74, 0x20, 0x3c, 0x68, 0x31, 
	0x3e, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x20, 0x63, 
	0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 
	0x3c, 0x2f, 0x68, 0x31, 0x3e, 0x3c, 0x62, 0x72, 0x3e, 0x3c, 
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x77, 0x69, 0x64, 0x74, 
	0x68, 0x3d, 0x22, 0x31, 0x30, 0x30, 0x25, 0x22, 0x3e, 0xa, 
	0x74, 0x20, 0x3c, 0x74, 0x72, 0x3e, 0x3c, 0x74, 0x68, 0x3e, 
	0x52, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x3c, 0x2f, 0x74, 0x68, 
	0x3e, 0x3c, 0x74, 0x68, 0x3e, 0x53, 0x74, 0x61, 0x74, 0x65, 
	0x3c, 0x2f, 0x74, 0x68, 0x3e, 0x3c, 0x74, 0x68, 0x3e, 0x52, 
	0x65, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69, 0x73, 0x73, 
	0x69, 0x6f, 0x6e, 0x73, 0x3c, 0x2f, 0x74, 0x68, 0x3e, 0x3c, 
	0x74, 0x68, 0x3e, 0x54, 0x69, 0x6d, 0x65, 0x72, 0x3c, 0x2f, 
	0x74, 0x68, 0x3e, 0x3c, 0x74, 0x68, 0x3e, 0x46, 0x6c, 0x61, 
	0x67, 0x73, 0x3c, 0x2f, 0x74, 0x68, 0x3e, 0x3c, 0x2f, 0x74, 
	0x72, 0x3e, 0xa, 0x63, 0x20, 0x62, 0xa, 0x74, 0x20, 0x3c, 
	0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3e, 0xa, 0x69, 0x20, 
	0x2f, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x6c, 
	0x61, 0x69, 0x6e, 0xa, 0x2e, };

static const char data_cgi_d64[] = {
	/* /cgi/d64 */
	0x2f, 0x63, 0x67, 0x69, 0x2f, 0x64, 0x36, 0x34, 0,
	0x69, 0x20, 0x2f, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x68, 
	0x65, 0x61, 0x64, 0x65, 0x72, 0x2e, 0x70, 0x6c, 0x61, 0x69, 
	0x6e, 0xa, 0x63, 0x20, 0x64, 0xa, 0x2e, 0xa, };

static const char data_index_html[] = {
	/* /index.html */
	0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x68, 0x74, 0x6d, 0x6c, 0,
	0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x20, 0x32, 
	0x30, 0x30, 0x20, 0x4f, 0x4b, 0xd, 0xa, 0x53, 0x65, 0x72, 
	0x76, 0x65, 0x72, 0x3a, 0x20, 0x43, 0x6f, 0x6e, 0x74, 0x69, 
	0x6b, 0x69, 0x2f, 0x70, 0x72, 0x65, 0x2d, 0x31, 0x2e, 0x31, 
	0x20, 0x28, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x64, 
	0x75, 0x6e, 0x6b, 0x65, 0x6c, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 
	0x2f, 0x61, 0x64, 0x61, 0x6d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 
	0x69, 0x6b, 0x69, 0x2f, 0x29, 0xd, 0xa, 0x43, 0x6f, 0x6e, 
	0x74, 0x65, 0x6e, 0x74, 0x2d, 0x74, 0x79, 0x70, 0x65, 0x3a, 
	0x20, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 
	0xd, 0xa, 0xd, 0xa, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 
	0x3c, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x3c, 0x74, 0x69, 0x74, 
	0x6c, 0x65, 0x3e, 0x54, 0x68, 0x65, 0x20, 0x43, 0x6f, 0x6e, 
	0x74, 0x69, 0x6b, 0x69, 0x20, 0x77, 0x65, 0x62, 0x20, 0x73, 
	0x65, 0x72, 0x76, 0x65, 0x72, 0x21, 0x3c, 0x2f, 0x74, 0x69, 
	0x74, 0x6c, 0x65, 0x3e, 0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64, 
	0x3e, 0xa, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x62, 0x67, 
	0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3d, 0x22, 0x77, 0x68, 0x69, 
	0x74, 0x65, 0x22, 0x3e, 0xa, 0x3c, 0x74, 0x61, 0x62, 0x6c, 
	0x65, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 
	0x30, 0x30, 0x25, 0x22, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 
	0x72, 0x3d, 0x22, 0x30, 0x22, 0x3e, 0xa, 0x3c, 0x74, 0x72, 
	0x3e, 0x3c, 0x74, 0x64, 0x3e, 0x3c, 0x69, 0x6d, 0x67, 0x20, 
	0x73, 0x72, 0x63, 0x3d, 0x22, 0x63, 0x6f, 0x6e, 0x74, 0x69, 
	0x6b, 0x69, 0x2e, 0x70, 0x6e, 0x67, 0x22, 0x3e, 0x3c, 0x2f, 
	0x74, 0x64, 0x3e, 0xa, 0x3c, 0x74, 0x64, 0x20, 0x61, 0x6c, 
	0x69, 0x67, 0x6e, 0x3d, 0x22, 0x63, 0x65, 0x6e, 0x74, 0x65, 
	0x72, 0x22, 0x3e, 0x3c, 0x68, 0x31, 0x3e, 0x57, 0x65, 0x6c, 
	0x63, 0x6f, 0x6d, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 
	0x65, 0x20, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6b, 0x69, 0x20, 
	0x77, 0x65, 0x62, 0x20, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 
	0x21, 0x3c, 0x2f, 0x68, 0x31, 0x3e, 0x3c, 0x2f, 0x74, 0x64, 
	0x3e, 0xa, 0x3c, 0x74, 0x64, 0x3e, 0x3c, 0x69, 0x6d, 0x67, 
	0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x77, 0x65, 0x62, 0x73, 
	0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x70, 0x6e, 0x67, 0x22, 
	0x3e, 0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x3c, 0x2f, 0x74, 0x72, 
	0x3e, 0x3c, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3e, 0x3c, 
	0x62, 0x72, 0x3e, 0xa, 0x3c, 0x62, 0x3e, 0x3c, 0x63, 0x65, 
	0x6e, 0x74, 0x65, 0x72, 0x3e, 0x54, 0x68, 0x65, 0x73, 0x65, 
	0x20, 0x77, 0x65, 0x62, 0x20, 0x70, 0x61, 0x67, 0x65, 0x73, 
	0x20, 0x61, 0x72, 0x65, 0x20, 0x73, 0x65, 0x72, 0x76, 0x65, 
	0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x79, 0x6f, 0x75, 
	0x72, 0x20, 0x43, 0x36, 0x34, 0x21, 0x3c, 0x2f, 0x63, 0x65, 
	0x6e, 0x74, 0x65, 0x72, 0x3e, 0x3c, 0x2f, 0x62, 0x3e, 0xa, 
	0x3c, 0x75, 0x6c, 0x3e, 0x3c, 0x6c, 0x69, 0x3e, 0x3c, 0x61, 
	0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x2f, 0x38, 0x2f, 
	0x22, 0x3e, 0x44, 0x69, 0x73, 0x6b, 0x20, 0x64, 0x69, 0x72, 
	0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x3c, 0x2f, 0x61, 0x3e, 
	0x3c, 0x62, 0x72, 0x3e, 0xa, 0x3c, 0x6c, 0x69, 0x3e, 0x3c, 
	0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x2f, 0x63, 
	0x67, 0x69, 0x2f, 0x64, 0x36, 0x34, 0x22, 0x3e, 0x44, 0x6f, 
	0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x20, 0x65, 0x6e, 0x74, 
	0x69, 0x72, 0x65, 0x20, 0x64, 0x69, 0x73, 0x6b, 0x20, 0x69, 
	0x6e, 0x20, 0x61, 0x73, 0x20, 0x61, 0x20, 0x44, 0x36, 0x34, 
	0x20, 0x66, 0x69, 0x6c, 0x65, 0x3c, 0x2f, 0x61, 0x3e, 0x2e, 
	0x3c, 0x62, 0x72, 0x3e, 0xa, 0x3c, 0x6c, 0x69, 0x3e, 0x3c, 
	0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x2f, 0x63, 
	0x67, 0x69, 0x2f, 0x74, 0x63, 0x70, 0x22, 0x3e, 0x43, 0x75, 
	0x72, 0x72, 0x65, 0x6e, 0x74, 0x20, 0x6e, 0x65, 0x74, 0x77, 
	0x6f, 0x72, 0x6b, 0x20, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 
	0x62, 0x72, 0x3e, 0xa, 0x3c, 0x6c, 0x69, 0x3e, 0x3c, 0x61, 
	0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x2f, 0x63, 0x67, 
	0x69, 0x2f, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 
	0x73, 0x22, 0x3e, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x20, 
	0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x3c, 
	0x2f, 0x61, 0x3e, 0x3c, 0x62, 0x72, 0x3e, 0xa, 0x3c, 0x2f, 
	0x75, 0x6c, 0x3e, 0xa, 0x54, 0x68, 0x65, 0x20, 0x43, 0x6f, 
	0x6e, 0x74, 0x69, 0x6b, 0x69, 0x20, 0x68, 0x6f, 0x6d, 0x65, 
	0x70, 0x61, 0x67, 0x65, 0x3a, 0x20, 0x3c, 0x61, 0x20, 0x68, 
	0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 
	0x2f, 0x2f, 0x64, 0x75, 0x6e, 0x6b, 0x65, 0x6c, 0x73, 0x2e, 
	0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x64, 0x61, 0x6d, 0x2f, 0x63, 
	0x6f, 0x6e, 0x74, 0x69, 0x6b, 0x69, 0x2f, 0x22, 0x3e, 0x3c, 
	0x74, 0x74, 0x3e, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 
	0x64, 0x75, 0x6e, 0x6b, 0x65, 0x6c, 0x73, 0x2e, 0x63, 0x6f, 
	0x6d, 0x2f, 0x61, 0x64, 0x61, 0x6d, 0x2f, 0x63, 0x6f, 0x6e, 
	0x74, 0x69, 0x6b, 0x69, 0x2f, 0x3c, 0x2f, 0x74, 0x74, 0x3e, 
	0x3c, 0x2f, 0x61, 0x3e, 0x2e, 0xa, 0x3c, 0x2f, 0x62, 0x6f, 
	0x64, 0x79, 0x3e, 0x3c, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 
};

static const char data_404_html[] = {
	/* /404.html */
	0x2f, 0x34, 0x30, 0x34, 0x2e, 0x68, 0x74, 0x6d, 0x6c, 0,
	0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x20, 0x32, 
	0x30, 0x30, 0x20, 0x4f, 0x4b, 0xd, 0xa, 0x53, 0x65, 0x72, 
	0x76, 0x65, 0x72, 0x3a, 0x20, 0x43, 0x6f, 0x6e, 0x74, 0x69, 
	0x6b, 0x69, 0x2f, 0x70, 0x72, 0x65, 0x2d, 0x31, 0x2e, 0x31, 
	0x20, 0x28, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x64, 
	0x75, 0x6e, 0x6b, 0x65, 0x6c, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 
	0x2f, 0x61, 0x64, 0x61, 0x6d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 
	0x69, 0x6b, 0x69, 0x2f, 0x29, 0xd, 0xa, 0x43, 0x6f, 0x6e, 
	0x74, 0x65, 0x6e, 0x74, 0x2d, 0x74, 0x79, 0x70, 0x65, 0x3a, 
	0x20, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 
	0xd, 0xa, 0xd, 0xa, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 
	0x3c, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x62, 0x67, 0x63, 0x6f, 
	0x6c, 0x6f, 0x72, 0x3d, 0x22, 0x77, 0x68, 0x69, 0x74, 0x65, 
	0x22, 0x3e, 0x3c, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3e, 
	0x3c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x77, 0x69, 0x64, 
	0x74, 0x68, 0x3d, 0x22, 0x36, 0x30, 0x30, 0x22, 0x20, 0x62, 
	0x6f, 0x72, 0x64, 0x65, 0x72, 0x3d, 0x22, 0x30, 0x22, 0x3e, 
	0x3c, 0x74, 0x72, 0x3e, 0x3c, 0x74, 0x64, 0x3e, 0x3c, 0x68, 
	0x31, 0x3e, 0x34, 0x30, 0x34, 0x20, 0x2d, 0x20, 0x66, 0x69, 
	0x6c, 0x65, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x66, 0x6f, 0x75, 
	0x6e, 0x64, 0x3c, 0x2f, 0x68, 0x31, 0x3e, 0x3c, 0x2f, 0x74, 
	0x72, 0x3e, 0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x3c, 0x2f, 0x74, 
	0x61, 0x62, 0x6c, 0x65, 0x3e, 0x3c, 0x2f, 0x63, 0x65, 0x6e, 
	0x74, 0x65, 0x72, 0x3e, 0x3c, 0x2f, 0x62, 0x6f, 0x64, 0x79, 
	0x3e, 0x3c, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3e, };

static const char data_header_html[] = {
	/* /header.html */
	0x2f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x2e, 0x68, 0x74, 0x6d, 0x6c, 0,
	0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x20, 0x32, 
	0x30, 0x30, 0x20, 0x4f, 0x4b, 0xd, 0xa, 0x53, 0x65, 0x72, 
	0x76, 0x65, 0x72, 0x3a, 0x20, 0x43, 0x6f, 0x6e, 0x74, 0x69, 
	0x6b, 0x69, 0x2f, 0x70, 0x72, 0x65, 0x2d, 0x31, 0x2e, 0x31, 
	0x20, 0x28, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x64, 
	0x75, 0x6e, 0x6b, 0x65, 0x6c, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 
	0x2f, 0x61, 0x64, 0x61, 0x6d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 
	0x69, 0x6b, 0x69, 0x2f, 0x29, 0xd, 0xa, 0x43, 0x6f, 0x6e, 
	0x74, 0x65, 0x6e, 0x74, 0x2d, 0x74, 0x79, 0x70, 0x65, 0x3a, 
	0x20, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 
	0xd, 0xa, 0xd, 0xa, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 
	0x3c, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x3c, 0x74, 0x69, 0x74, 
	0x6c, 0x65, 0x3e, 0x54, 0x68, 0x65, 0x20, 0x43, 0x6f, 0x6e, 
	0x74, 0x69, 0x6b, 0x69, 0x20, 0x77, 0x65, 0x62, 0x20, 0x73, 
	0x65, 0x72, 0x76, 0x65, 0x72, 0x21, 0x3c, 0x2f, 0x74, 0x69, 
	0x74, 0x6c, 0x65, 0x3e, 0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64, 
	0x3e, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x62, 0x67, 0x63, 
	0x6f, 0x6c, 0x6f, 0x72, 0x3d, 0x22, 0x77, 0x68, 0x69, 0x74, 
	0x65, 0x22, 0x3e, 0xa, };

static const char data_footer_plain[] = {
	/* /footer.plain */
	0x2f, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0,
	0x54, 0x68, 0x65, 0x20, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6b, 
	0x69, 0x20, 0x68, 0x6f, 0x6d, 0x65, 0x70, 0x61, 0x67, 0x65, 
	0x3a, 0x20, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 
	0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x64, 0x75, 
	0x6e, 0x6b, 0x65, 0x6c, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 
	0x61, 0x64, 0x61, 0x6d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x69, 
	0x6b, 0x69, 0x2f, 0x22, 0x3e, 0x3c, 0x74, 0x74, 0x3e, 0x68, 
	0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x64, 0x75, 0x6e, 0x6b, 
	0x65, 0x6c, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x64, 
	0x61, 0x6d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6b, 0x69, 
	0x2f, 0x3c, 0x2f, 0x74, 0x74, 0x3e, 0x3c, 0x2f, 0x61, 0x3e, 
	0x2e, 0x3c, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x3c, 0x2f, 
	0x68, 0x74, 0x6d, 0x6c, 0x3e, };

static const char data_webserver_png[] = {
	/* /webserver.png */
	0x2f, 0x77, 0x65, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2e, 0x70, 0x6e, 0x67, 0,
	0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x20, 0x32, 
	0x30, 0x30, 0x20, 0x4f, 0x4b, 0xd, 0xa, 0x53, 0x65, 0x72, 
	0x76, 0x65, 0x72, 0x3a, 0x20, 0x43, 0x6f, 0x6e, 0x74, 0x69, 
	0x6b, 0x69, 0x2f, 0x70, 0x72, 0x65, 0x2d, 0x31, 0x2e, 0x31, 
	0x20, 0x28, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x64, 
	0x75, 0x6e, 0x6b, 0x65, 0x6c, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 
	0x2f, 0x61, 0x64, 0x61, 0x6d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 
	0x69, 0x6b, 0x69, 0x2f, 0x29, 0xd, 0xa, 0x43, 0x6f, 0x6e, 
	0x74, 0x65, 0x6e, 0x74, 0x2d, 0x74, 0x79, 0x70, 0x65, 0x3a, 
	0x20, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2f, 0x70, 0x6e, 0x67, 
	0xd, 0xa, 0xd, 0xa, 0x89, 0x50, 0x4e, 0x47, 0xd, 0xa, 
	0x1a, 0xa, 00, 00, 00, 0xd, 0x49, 0x48, 0x44, 0x52, 
	00, 00, 00, 0x18, 00, 00, 00, 0x18, 0x1, 00, 
	00, 00, 00, 0xc8, 0xc, 00, 0x55, 00, 00, 00, 
	0x2, 0x62, 0x4b, 0x47, 0x44, 00, 0x1, 0xdd, 0x8a, 0x13, 
	0xa4, 00, 00, 00, 0x5d, 0x49, 0x44, 0x41, 0x54, 0x78, 
	0xda, 0x1d, 0xc8, 0x21, 0xa, 0x80, 0x30, 00, 0x46, 0xe1, 
	0xa7, 0xc7, 0x34, 0x78, 0x93, 0x89, 0xb, 0x1e, 0x43, 0x96, 
	0x8c, 0x62, 0x14, 0x19, 0x6e, 0xc1, 0xe8, 0x19, 0x96, 0x97, 
	0x8c, 0x6, 0xc3, 0xf8, 0x45, 0xc3, 0x83, 0x8f, 0x87, 0x24, 
	0x7a, 0x2a, 0xe2, 0x54, 0x8, 0x32, 0x78, 0x25, 0x56, 0x5d, 
	0xc4, 0xa3, 0xb0, 0x74, 0xf7, 0xff, 0x9c, 0x1e, 0x76, 0xed, 
	0x8c, 0x79, 0xfb, 0xfb, 0xec, 0xf2, 0x43, 0xc8, 0x86, 0xa5, 
	0xb9, 0x89, 0x67, 0x61, 0x3d, 0x2e, 0xfc, 0x9c, 0x8, 0x83, 
	0x21, 0xda, 0x82, 0x6d, 0x2d, 0xaa, 0xf5, 0x2, 0x33, 0x91, 
	0x35, 0x61, 0x3a, 0xe8, 0xa4, 0x34, 00, 00, 00, 00, 
	0x49, 0x45, 0x4e, 0x44, 0xae, 0x42, 0x60, 0x82, };

static const char data_contiki_png[] = {
	/* /contiki.png */
	0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6b, 0x69, 0x2e, 0x70, 0x6e, 0x67, 0,
	0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x20, 0x32, 
	0x30, 0x30, 0x20, 0x4f, 0x4b, 0xd, 0xa, 0x53, 0x65, 0x72, 
	0x76, 0x65, 0x72, 0x3a, 0x20, 0x43, 0x6f, 0x6e, 0x74, 0x69, 
	0x6b, 0x69, 0x2f, 0x70, 0x72, 0x65, 0x2d, 0x31, 0x2e, 0x31, 
	0x20, 0x28, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x64, 
	0x75, 0x6e, 0x6b, 0x65, 0x6c, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 
	0x2f, 0x61, 0x64, 0x61, 0x6d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 
	0x69, 0x6b, 0x69, 0x2f, 0x29, 0xd, 0xa, 0x43, 0x6f, 0x6e, 
	0x74, 0x65, 0x6e, 0x74, 0x2d, 0x74, 0x79, 0x70, 0x65, 0x3a, 
	0x20, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2f, 0x70, 0x6e, 0x67, 
	0xd, 0xa, 0xd, 0xa, 0x89, 0x50, 0x4e, 0x47, 0xd, 0xa, 
	0x1a, 0xa, 00, 00, 00, 0xd, 0x49, 0x48, 0x44, 0x52, 
	00, 00, 00, 0x18, 00, 00, 00, 0x18, 0x8, 0x2, 
	00, 00, 00, 0x6f, 0x15, 0xaa, 0xaf, 00, 00, 00, 
	0x9, 0x70, 0x48, 0x59, 0x73, 00, 00, 0x1c, 0x1f, 00, 
	00, 0x1c, 0x1f, 0x1, 0x60, 0xfd, 0x4, 0xda, 00, 00, 
	00, 0x7, 0x74, 0x49, 0x4d, 0x45, 0x7, 0xd3, 0x3, 0x9, 
	0x16, 0x4, 0xd, 0x60, 0xa0, 0x97, 00, 00, 00, 00, 
	0xad, 0x49, 0x44, 0x41, 0x54, 0x78, 0x9c, 0xad, 0x94, 0x41, 
	0xe, 0xc5, 0x20, 0x8, 0x44, 0x9d, 0x1f, 0xee, 0x7f, 0xe5, 
	0xf9, 0xb, 0x13, 0x6a, 0x1, 0x29, 0xa5, 0xb2, 0x53, 0xca, 
	0xf0, 0x9c, 0x40, 0x41, 0x72, 0x1c, 0x89, 0x23, 0x42, 0x24, 
	0xc5, 0xcb, 0x1, 0x48, 0x1a, 0xf8, 0xec, 0xbc, 0x91, 0xe4, 
	0xa3, 0x79, 0x34, 0x9d, 0x67, 0xd6, 0xcb, 0x5d, 0x42, 0x3e, 
	0x97, 0xbc, 0x9a, 0x24, 00, 00, 0xfa, 0x8d, 0x98, 0x74, 
	0x8, 0x12, 0xa, 0x4d, 0xad, 0x8b, 0x43, 0xcf, 0x3d, 0xd7, 
	0xb5, 0x36, 0xf0, 0xa8, 0x1e, 0x81, 0x47, 0xf3, 0xaa, 0x1, 
	0xa5, 0xf, 0xb2, 0x66, 0x37, 0x84, 0x6e, 0x44, 0x3d, 0x9c, 
	0x35, 0x3a, 0x44, 0x61, 0xcb, 0x26, 0x91, 0xef, 0xfa, 0x82, 
	0x28, 0x9f, 0xb2, 0x77, 0x44, 0x49, 0xb3, 0xd2, 0x1c, 0x55, 
	0x26, 0x5e, 0x54, 0x42, 0x17, 0xf2, 0x91, 0x25, 0xdc, 0x6a, 
	0x49, 0xa, 0x4c, 0x99, 0x3f, 0xae, 0xeb, 0x26, 0xeb, 0xd5, 
	0xe, 0xaa, 0x32, 0x19, 0xd6, 0x23, 0x6f, 0x47, 0x71, 0x2c, 
	0x7e, 0xa6, 0x40, 0xb7, 0x59, 0x23, 0xa1, 0xdb, 0x7a, 0xb4, 
	0xfb, 0xfb, 0x25, 0x5a, 0xb6, 0xf8, 0x63, 0x90, 0xc4, 0x11, 
	0xa1, 0x31, 0xc6, 0x1f, 0x2c, 0x64, 0x9c, 0x21, 0xc5, 0x1a, 
	0x66, 0x5d, 00, 00, 00, 00, 0x49, 0x45, 0x4e, 0x44, 
	0xae, 0x42, 0x60, 0x82, };

static const char data_binaryheader_plain[] = {
	/* /binaryheader.plain */
	0x2f, 0x62, 0x69, 0x6e, 0x61, 0x72, 0x79, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x2e, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0,
	0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x20, 0x32, 
	0x30, 0x30, 0x20, 0x4f, 0x4b, 0xd, 0xa, 0x43, 0x6f, 0x6e, 
	0x74, 0x65, 0x6e, 0x74, 0x2d, 0x74, 0x79, 0x70, 0x65, 0x3a, 
	0x20, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 
	0x6f, 0x6e, 0x2f, 0x6f, 0x63, 0x74, 0x65, 0x74, 0x2d, 0x73, 
	0x74, 0x72, 0x65, 0x61, 0x6d, 0xd, 0xa, 0xd, 0xa, };

static const char data_dirheader_html[] = {
	/* /dirheader.html */
	0x2f, 0x64, 0x69, 0x72, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x2e, 0x68, 0x74, 0x6d, 0x6c, 0,
	0x48, 0x54, 0x54, 0x50, 0x2f, 0x31, 0x2e, 0x30, 0x20, 0x32, 
	0x30, 0x30, 0x20, 0x4f, 0x4b, 0xd, 0xa, 0x53, 0x65, 0x72, 
	0x76, 0x65, 0x72, 0x3a, 0x20, 0x43, 0x6f, 0x6e, 0x74, 0x69, 
	0x6b, 0x69, 0x2f, 0x70, 0x72, 0x65, 0x2d, 0x31, 0x2e, 0x31, 
	0x20, 0x28, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x64, 
	0x75, 0x6e, 0x6b, 0x65, 0x6c, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 
	0x2f, 0x61, 0x64, 0x61, 0x6d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 
	0x69, 0x6b, 0x69, 0x2f, 0x29, 0xd, 0xa, 0x43, 0x6f, 0x6e, 
	0x74, 0x65, 0x6e, 0x74, 0x2d, 0x74, 0x79, 0x70, 0x65, 0x3a, 
	0x20, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 
	0xd, 0xa, 0xd, 0xa, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 
	0x3c, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x3c, 0x74, 0x69, 0x74, 
	0x6c, 0x65, 0x3e, 0x54, 0x68, 0x65, 0x20, 0x43, 0x6f, 0x6e, 
	0x74, 0x69, 0x6b, 0x69, 0x20, 0x77, 0x65, 0x62, 0x20, 0x73, 
	0x65, 0x72, 0x76, 0x65, 0x72, 0x21, 0x3c, 0x2f, 0x74, 0x69, 
	0x74, 0x6c, 0x65, 0x3e, 0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64, 
	0x3e, 0xa, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x62, 0x67, 
	0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3d, 0x22, 0x77, 0x68, 0x69, 
	0x74, 0x65, 0x22, 0x3e, 0xa, 0x3c, 0x63, 0x65, 0x6e, 0x74, 
	0x65, 0x72, 0x3e, 0x3c, 0x68, 0x31, 0x3e, 0x46, 0x69, 0x6c, 
	0x65, 0x73, 0x20, 0x6f, 0x6e, 0x20, 0x64, 0x69, 0x73, 0x6b, 
	0x3c, 0x2f, 0x68, 0x31, 0x3e, 0xa, 0x3c, 0x74, 0x61, 0x62, 
	0x6c, 0x65, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 
	0x31, 0x30, 0x30, 0x25, 0x22, 0x20, 0x62, 0x6f, 0x72, 0x64, 
	0x65, 0x72, 0x3d, 0x22, 0x30, 0x22, 0x3e, 0x3c, 0x74, 0x68, 
	0x3e, 0x46, 0x69, 0x6c, 0x65, 0x3c, 0x2f, 0x74, 0x68, 0x3e, 
	0x3c, 0x74, 0x68, 0x3e, 0x53, 0x69, 0x7a, 0x65, 0x20, 0x28, 
	0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x29, 0x3c, 0x2f, 0x74, 
	0x68, 0x3e, };

static const char data_dirfooter_plain[] = {
	/* /dirfooter.plain */
	0x2f, 0x64, 0x69, 0x72, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2e, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0,
	0x3c, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3e, 0x3c, 0x2f, 
	0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3e, 0x54, 0x68, 0x65, 
	0x20, 0x43, 0x6f, 0x6e, 0x74, 0x69, 0x6b, 0x69, 0x20, 0x68, 
	0x6f, 0x6d, 0x65, 0x70, 0x61, 0x67, 0x65, 0x3a, 0x20, 0x3c, 
	0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 
	0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x64, 0x75, 0x6e, 0x6b, 0x65, 
	0x6c, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x64, 0x61, 
	0x6d, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6b, 0x69, 0x2f, 
	0x22, 0x3e, 0x3c, 0x74, 0x74, 0x3e, 0x68, 0x74, 0x74, 0x70, 
	0x3a, 0x2f, 0x2f, 0x64, 0x75, 0x6e, 0x6b, 0x65, 0x6c, 0x73, 
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x64, 0x61, 0x6d, 0x2f, 
	0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6b, 0x69, 0x2f, 0x3c, 0x2f, 
	0x74, 0x74, 0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x2e, 0x3c, 0x2f, 
	0x62, 0x6f, 0x64, 0x79, 0x3e, 0x3c, 0x2f, 0x68, 0x74, 0x6d, 
	0x6c, 0x3e, };

const struct httpd_fsdata_file file_cgi_processes[] = {{NULL, data_cgi_processes, data_cgi_processes + 15, sizeof(data_cgi_processes) - 15}};

const struct httpd_fsdata_file file_cgi_tcp[] = {{file_cgi_processes, data_cgi_tcp, data_cgi_tcp + 9, sizeof(data_cgi_tcp) - 9}};

const struct httpd_fsdata_file file_cgi_d64[] = {{file_cgi_tcp, data_cgi_d64, data_cgi_d64 + 9, sizeof(data_cgi_d64) - 9}};

const struct httpd_fsdata_file file_index_html[] = {{file_cgi_d64, data_index_html, data_index_html + 12, sizeof(data_index_html) - 12}};

const struct httpd_fsdata_file file_404_html[] = {{file_index_html, data_404_html, data_404_html + 10, sizeof(data_404_html) - 10}};

const struct httpd_fsdata_file file_header_html[] = {{file_404_html, data_header_html, data_header_html + 13, sizeof(data_header_html) - 13}};

const struct httpd_fsdata_file file_footer_plain[] = {{file_header_html, data_footer_plain, data_footer_plain + 14, sizeof(data_footer_plain) - 14}};

const struct httpd_fsdata_file file_webserver_png[] = {{file_footer_plain, data_webserver_png, data_webserver_png + 15, sizeof(data_webserver_png) - 15}};

const struct httpd_fsdata_file file_contiki_png[] = {{file_webserver_png, data_contiki_png, data_contiki_png + 13, sizeof(data_contiki_png) - 13}};

const struct httpd_fsdata_file file_binaryheader_plain[] = {{file_contiki_png, data_binaryheader_plain, data_binaryheader_plain + 20, sizeof(data_binaryheader_plain) - 20}};

const struct httpd_fsdata_file file_dirheader_html[] = {{file_binaryheader_plain, data_dirheader_html, data_dirheader_html + 16, sizeof(data_dirheader_html) - 16}};

const struct httpd_fsdata_file file_dirfooter_plain[] = {{file_dirheader_html, data_dirfooter_plain, data_dirfooter_plain + 17, sizeof(data_dirfooter_plain) - 17}};

#define HTTPD_FS_ROOT file_dirfooter_plain

#define HTTPD_FS_NUMFILES 12